/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsDialog;

public class TokensDigramsActionListener
implements ActionListener {
    private TokensDigramsDialog tokensDigramsDialog;

    public TokensDigramsActionListener(TokensDigramsDialog tokensDigramsDialog, boolean isToken) {
        this.tokensDigramsDialog = tokensDigramsDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            CursorChangeEffect.setCustomCursor(3);
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("Clear")) {
                this.tokensDigramsDialog.fillInTheTokensDigramsTable(this.tokensDigramsDialog.isACorpus());
            } else if (actionCommand.equals("SelectAll")) {
                JTable tokensTable = this.tokensDigramsDialog.getTableTokensDigrams();
                tokensTable.setRowSelectionAllowed(true);
                int rowCount = tokensTable.getRowCount();
                tokensTable.setRowSelectionInterval(0, rowCount - 1);
            } else if (actionCommand.equals("Filter")) {
                JTable tokensTable = this.tokensDigramsDialog.getTableTokensDigrams();
                DefaultTableModel tableModel = (DefaultTableModel)tokensTable.getModel();
                int[] selectedRowNumbers = tokensTable.getSelectedRows();
                int selectedRowsNumber = selectedRowNumbers.length;
                for (int k = 0; k < selectedRowsNumber; ++k) {
                    selectedRowNumbers[k] = tokensTable.convertRowIndexToModel(selectedRowNumbers[k]);
                }
                if (selectedRowsNumber == 0) {
                    return;
                }
                ArrayList<Object[]> listOfSelectedItems = new ArrayList<Object[]>();
                for (int i = 0; i < selectedRowsNumber; ++i) {
                    Object[] obj = new Object[]{tableModel.getValueAt(selectedRowNumbers[i], 0), tableModel.getValueAt(selectedRowNumbers[i], 1)};
                    listOfSelectedItems.add(obj);
                }
                tableModel.getDataVector().removeAllElements();
                tableModel.fireTableDataChanged();
                for (Object[] selectedTokenDigram : listOfSelectedItems) {
                    tableModel.addRow(selectedTokenDigram);
                }
            } else if (actionCommand.equals("Export")) {
                this.tokensDigramsDialog.fillTheDictionary();
            }
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }
}

